package com.example.aqk2kdemo;

import android.content.Intent;
import android.content.res.AssetManager;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import aqkanji2koe.AqKanji2Koe;
import aquestalk.AquesTalk;	// AquesTalk10  別途libAquesTalk.soが必要

public class MainActivity extends AppCompatActivity implements View.OnClickListener {
    AquesTalk aquestalk;
    AudioTrack audioTrack;
    private static final String TAG = "AqK2kDemo";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        // 初期起動時に辞書データassets/aq_dic.zipをfileの下に展開
        copyDic();

        aquestalk = new AquesTalk();    // AquesTalk10 Android

        // ライセンスキー設定
        // ライセンス購入時のライセンス証に記載されているものを指定 これで評価版の制限がなくなる
        AqKanji2Koe.setDevKey("YYY-YYY-YYY");
        AquesTalk.setDevKey("ZZZ-ZZZ-ZZZ");
        // 使用ライセンスキーはエンドユーザが設定するので、実際はハードコーディングでなく設定画面を用意する
        AquesTalk.setUsrKey("UUU-UUU-UUU");

        findViewById(R.id.btnUsrDic).setOnClickListener(this);
        findViewById(R.id.btnConv).setOnClickListener(this);
        findViewById(R.id.btnPlay).setOnClickListener(this);

    }
    public void onClick(View v){
        if (v != null) {
            int id = v.getId();
            if(id == R.id.btnUsrDic){
                // UsrDicボタンが押された
                Intent intent = new Intent(this, UsrDicActivity.class );
                startActivity(intent);
            }
            else if( id== R.id.btnConv) {
                // Convertボタンが押された
                EditText textKanji = findViewById(R.id.editKanji);
                String dirDic = getFilesDir().toString();	// /data/data/<package name>/files
                String kanji = textKanji.getText().toString();
                String strKoe = AqKanji2Koe.convert(dirDic, kanji);
                EditText textKoe = findViewById(R.id.editKoe);
                textKoe.setText(strKoe, TextView.BufferType.SPANNABLE);
            }
            else if(id==R.id.btnPlay){
                // PLAYボタンが押された
                EditText editKoe = findViewById(R.id.editKoe);
                String koe = editKoe.getText().toString();
                onPlayBtn(koe);
            }
        }
    }

    private void onPlayBtn(String koe) {
        // 音声合成
        aquestalk.SetPreset(AquesTalk.PRESET.F1);//声種は
        byte[] wav = aquestalk.synthe(koe);
        if(wav.length==1){//生成エラー時には,長さ１で、先頭にエラーコードが返される
            Log.v("AqK2kDemo", "AquesTalk synthe ERROR:" + wav[0]);
            Toast.makeText(this, "音声記号列が正しい？："+wav[0], Toast.LENGTH_LONG).show();
        }
        else {	// 音声出力
            if(audioTrack!=null) {// インスタンスがあれば停止/解放
                audioTrack.stop();
                audioTrack.release();
            }
            audioTrack = new AudioTrack(
                    AudioManager.STREAM_MUSIC,
                    (wav[25] << 8) + wav[24], // WAVヘッダからサンプリF1ング周波数[Hz]を取得
                    AudioFormat.CHANNEL_OUT_MONO,
                    AudioFormat.ENCODING_PCM_16BIT,
                    wav.length - 44,
                    AudioTrack.MODE_STATIC);
            audioTrack.write(wav, 44, wav.length - 44);// 44:wavのヘッダサイズ
            audioTrack.play();
        }
    }

    // 初回起動時に辞書データを展開する
    // 別スレッドで処理
    // /data/data/<app>/files/copyed.datが存在しなかったら
    // /assets/aq_dic.zip を /data/data/<app>/files/に ファイルを展開
    private void copyDic(){
        try {
            // すでに展開済み？
            String filepath = this.getFilesDir().getAbsolutePath() + "/" +  "copyed.dat";
            File file = new File(filepath);
            boolean isExists = file.exists();

            if(!isExists){//展開済みでなかったら（初期起動時）
                new Thread(() -> {
                    try{
                        AssetManager am  = getResources().getAssets();
                        InputStream is  = am.open("aq_dic.zip", AssetManager.ACCESS_STREAMING);
                        ZipInputStream zis = new ZipInputStream(is);
                        ZipEntry ze  = zis.getNextEntry();

                        while (ze != null) {
                            String path = getFilesDir().toString() + "/" + ze.getName();
                            FileOutputStream fos = new FileOutputStream(path, false);
                            byte[] buf = new byte[8192];
                            int size;
                            while ((size = zis.read(buf, 0, buf.length)) > -1) {
                                fos.write(buf, 0, size);
                            }
                            fos.close();
                            zis.closeEntry();
                            ze  = zis.getNextEntry();
                        }
                        zis.close();
                        {// コピー完了のマークとして、copyed.datを作成
                            String filepath1 = getFilesDir().getAbsolutePath() + "/" +  "copyed.dat";
                            FileOutputStream fos = new FileOutputStream(filepath1, false);
                            byte[] buf = new byte[1];
                            buf[0]='*';
                            fos.write(buf, 0, 1);
                            fos.close();
                        }

                    } catch(Exception e){
                        Log.e(TAG, "辞書データを展開中に例外が発生", e);
                    }
                }).start();
            }
        } catch (Exception e) {
            Log.e(TAG, "辞書データのファイル確認中に例外が発生", e);
        }
    }
}