package com.example.aqk2kdemo;

import androidx.activity.EdgeToEdge;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ListView;

import android.widget.Toast;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import aqusrdic.AqUsrDic;

public class UsrDicActivity extends AppCompatActivity  implements View.OnClickListener {
    private List<WordItem> wordList;
    private WordListAdapter adapter;
    int positionSelected; // Addの場合は-1
    private static final String TAG = "AquesTalkTts";

    private ActivityResultLauncher<Intent> wordEditLauncher;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_usr_dic);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.usr_dic), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        wordEditLauncher = registerForActivityResult(
                new ActivityResultContracts.StartActivityForResult(),
                result -> {
                    //編集画面から戻ってきたときの処理
                    if (result.getResultCode() == Activity.RESULT_OK) {
                        Intent data = result.getData();
                        if (data != null) {
                            String surface = data.getStringExtra("Surface");
                            String yomi = data.getStringExtra("Yomi");
                            int posCode = data.getIntExtra("PosCode",0);
                            if(positionSelected == -1) {
                                // 先頭に1Word追加
                                WordItem item=new WordItem();
                                item.setData(surface, yomi, posCode);
                                wordList.add(0, item);
                            }
                            else {
                                //編集内容で更新
                                wordList.get(positionSelected).setData(surface,yomi,posCode);
                            }
                            adapter.notifyDataSetChanged();
                        }
                    }
                }
        );

        wordList = new ArrayList<>();
        adapter = new WordListAdapter(this, 0, wordList);

        ListView listView = findViewById(R.id.listViewWords);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener((parent, view, position, id) -> {
            //単語編集画面へ
            Intent intent = new Intent(UsrDicActivity.this, WordEditActivity.class);
            WordItem item = (WordItem)parent.getItemAtPosition(position);
            intent.putExtra("Surface", item.getSurface());
            intent.putExtra("Yomi", item.getYomi());
            intent.putExtra("PosCode", item.getPosCode());
            positionSelected = position;
            //startActivityForResult(intent,REQUEST_EDIT);
            wordEditLauncher.launch(intent);
        });
        loadUsrDic();//ユーザ辞書の読み込み

        findViewById(R.id.btnAdd).setOnClickListener(this);
        findViewById(R.id.btnSave).setOnClickListener(this);
        findViewById(R.id.btnCancel).setOnClickListener(this);
    }

    // Add/Save/Cancelボタンの処理
    public void onClick(View v) {
        if (v != null) {
            int id = v.getId();
            if(id==R.id.btnAdd){
                //　単語編集画面へ
                positionSelected = -1;
                Intent intent = new Intent(UsrDicActivity.this, WordEditActivity.class);
                //startActivityForResult(intent,REQUEST_ADD);
                wordEditLauncher.launch(intent);
            }
            else if(id==R.id.btnSave){
                saveUsrDic();
                // 辞書の再読み込み <<　TextToSpeechインスタンスの再Createで有効になる
                finish();
            }
            else if(id==R.id.btnCancel){
                finish();
            }
        }
    }

    // ユーザ辞書の読み込み
    // aq_user.dic -> aq_user.csv -> wordList
    private void loadUsrDic() {
        String fileUsrDic = getFilesDir().getAbsolutePath() + "/" +  "aq_user.dic";
        String fileUsrCsv = getFilesDir().getAbsolutePath() + "/" +  "aq_user.csv";
        int iret = AqUsrDic.exportCsv(fileUsrDic, fileUsrCsv);
        if(iret!=0){
            Toast.makeText(this, "ユーザ辞書の読み込み失敗1", Toast.LENGTH_LONG).show();
            finish();
        }
        //CSVファイルを読み込む
        try {
            FileReader fr = new FileReader(fileUsrCsv);
            BufferedReader br = new BufferedReader(fr);

            //読み込んだファイルを１行ずつ処理する
            String line;
            StringTokenizer token;
            while ((line = br.readLine()) != null) {
                //区切り文字","で分割する
                token = new StringTokenizer(line, ",");
                String surface = token.nextToken();
                String yomi    = token.nextToken();
                int posCode = Integer.parseInt(token.nextToken());
                WordItem item=new WordItem();
                item.setData(surface, yomi, posCode);
                wordList.add(item);
            }
            //終了処理
            br.close();
        } catch (FileNotFoundException ex) {
            //例外発生時処理
            Log.e(TAG,"ユーザ辞書の読み込み失敗2", ex);
            Toast.makeText(this, "ユーザ辞書の読み込み失敗2", Toast.LENGTH_LONG).show();
            finish();
        } catch (IOException ex) {
            //例外発生時処理
            Log.e(TAG,"ユーザ辞書の読み込み失敗3", ex);
            Toast.makeText(this, "ユーザ辞書の読み込み失敗3", Toast.LENGTH_LONG).show();
            finish();
        }
    }

    // ユーザ辞書の再構築
    private void saveUsrDic() {
        String fileUsrDic = getFilesDir().getAbsolutePath() + "/" +  "aq_user.dic";
        String fileUsrCsv = getFilesDir().getAbsolutePath() + "/" +  "aq_user.csv";
        // aq_user.csvへ書き出し
        try {
            FileWriter fw = new FileWriter(fileUsrCsv, false);
            PrintWriter pw = new PrintWriter(new BufferedWriter(fw));
            for (WordItem item : wordList) {
                pw.print(item.getSurface());
                pw.print(",");
                pw.print(item.getYomi());
                pw.print(",");
                pw.print(item.getPosCode());
                pw.println();
            }
            pw.close();
        } catch (IOException ex) {
            Log.e(TAG,"ユーザ辞書の書き込み失敗1", ex);
            Toast.makeText(this, "ユーザ辞書の書き込み失敗1", Toast.LENGTH_LONG).show();
            finish();
        }
        // aq_user.csv -> aq_user.dic
        int iret = AqUsrDic.importCsv(fileUsrDic, fileUsrCsv);
        if(iret!=0){
            Toast.makeText(this, "ユーザ辞書の書き込み失敗2", Toast.LENGTH_LONG).show();
            finish();
        }
    }

}
