package com.example.aqk2kdemo;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import aqusrdic.AqUsrDic;

public class WordEditActivity extends AppCompatActivity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_word_edit);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.word_edit), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        Intent intent = getIntent();
        String surface = intent.getStringExtra("Surface");
        String yomi    = intent.getStringExtra("Yomi");
        int posCode = intent.getIntExtra("PosCode",5);  // default 3?

        ((TextView)findViewById(R.id.editSurface)).setText(surface);
        ((TextView)findViewById(R.id.editYomi)).setText(yomi);
        ((Spinner)findViewById(R.id.spinPosCode)).setSelection(posCode);

        findViewById(R.id.btnSet).setOnClickListener(this);
        findViewById(R.id.btnCancel).setOnClickListener(this);

    }

    public void onClick(View v){
        if (v != null) {
            int id = v.getId();
            if(id==R.id.btnSet){
                String surface =  ((TextView)findViewById(R.id.editSurface)).getText().toString();
                String yomi =  ((TextView)findViewById(R.id.editYomi)).getText().toString();
                int posCode = ((Spinner)findViewById(R.id.spinPosCode)).getSelectedItemPosition();
                // 入力のチェックを行い、エラーのときはfinishしないでメッセージを出す
                int iret = AqUsrDic.checkEntry(surface, yomi,posCode);
                if(iret!=0){
                    Toast.makeText(this, "エラー:"+AqUsrDic.getLastError(), Toast.LENGTH_LONG).show();
                    return;
                }
                Intent intent = new Intent();
                intent.putExtra("Surface",surface);
                intent.putExtra("Yomi",yomi);
                intent.putExtra("PosCode",posCode);
                setResult(RESULT_OK, intent);
                finish();
            } else if(id==R.id.btnCancel){
                Intent intent2 = new Intent();
                setResult(RESULT_CANCELED, intent2);
                finish();
            }
        }
    }
}
