package com.example.aqk2kdemo;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.List;

public class WordListAdapter extends ArrayAdapter<WordItem> {

    private final LayoutInflater inflater;

    public WordListAdapter(Context context, int resource, List<WordItem> objects) {
        super(context, resource, objects);
        inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @NonNull
    @Override
    public View getView(final int position, @Nullable View convertView, @NonNull final ViewGroup parent) {
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.list_item, parent, false);
        }
        WordItem item = this.getItem(position);

        TextView textView = convertView.findViewById(R.id.listText);
        if (textView != null) {
            if (item != null) {
                textView.setText(item.getSurface());
            }
        }

        //削除ボタンの設定
        Button DeleteButton= convertView.findViewById(R.id.listDeleteBtn);
        DeleteButton.setOnClickListener(view -> {
            WordItem item1 = getItem(position);
            if (item1 != null) {
                remove(item1);
                Toast.makeText(view.getContext(), "削除しました", Toast.LENGTH_SHORT).show();
            }
        });

        return convertView;
    }

}