package aquestalk;

public class AquesTalk {
	static {
		System.loadLibrary("AquesTalk");
	}
	/**
	 * 音声記号列から音声データを生成します。JNI実装(native修飾子)
	 * <p>発話速度は通常の速度を100として、50 - 300 の間で指定します(単位は%)。</p>
	 * @param kanaText 音声記号列(UTF-8)
	 * @param speed 発話速度(%)
	 * @return wavフォーマットのデータ
	 */
	public synchronized native byte[] syntheWav(String kanaText, int speed);

	/**
	 * 開発ライセンスキーを指定
	 * <p>指定によりナ行マ行がヌになる評価版制限がなくなる</p>
	 * @param key 開発ライセンスキー
	 * @return 0: 正常 それ以外:キーが不正
	 */
	public synchronized native int setDevKey(String key);

	/**
	 * 使用ライセンスキーを指定
	 * <p>営利目的使用時に指定する</p>
	 * @param key 使用ライセンスキー
	 * @return 0: 正常 それ以外:キーが不正
	 */
	public synchronized native int setUsrKey(String key);


}
