package com.example.aqtkapp;

import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import aquestalk.AquesTalk;	// AquesTalkクラス 別途libAquesTalk.soが必要

public class MainActivity extends AppCompatActivity {
    AquesTalk aquestalk;
    AudioTrack audioTrack;
    private static final int FS = 8000;	//[Hz]

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);

        aquestalk = new AquesTalk();
        aquestalk.setDevKey("xxxxxxxxxxxxx");   // 開発ライセンスキーを指定
        aquestalk.setUsrKey("yyyyyyyyyyyyy");   // 使用ライセンスキーを指定

        Button playButton = (Button) findViewById(R.id.button_synthe);

        playButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {
                EditText textKoe = (EditText) findViewById(R.id.text_koe);
                EditText textSpeed = (EditText) findViewById(R.id.text_speed);
                String koe = textKoe.getText().toString();
                int speed = Integer.parseInt(textSpeed.getText().toString());
                onPlayBtn(koe, speed);
            }
        });

        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });
    }
    @Override
    public void onDestroy() {
        if(audioTrack!=null) audioTrack.release();
        super.onDestroy();
    }

    private void onPlayBtn(String koe, int speed) {
        // 音声合成
        byte[] wav = aquestalk.syntheWav(koe, speed);
        if(wav.length==1){//生成エラー時には,長さ１で、先頭にエラーコードが返される
            Log.v("AQTKAPP", "AquesTalk Synthe ERROR:"+wav[0]);
            Toast.makeText(this, "音声記号列が正しい？："+wav[0], Toast.LENGTH_LONG).show();
        }
        else {	// 音声出力
            if(audioTrack!=null) {// インスタンスがあれば停止/解放
                audioTrack.stop();
                audioTrack.release();
            }
            audioTrack = new AudioTrack(
                    AudioManager.STREAM_MUSIC,
                    FS,
                    AudioFormat.CHANNEL_OUT_MONO,
                    AudioFormat.ENCODING_PCM_16BIT,
                    wav.length-44,
                    AudioTrack.MODE_STATIC);
            audioTrack.write(wav, 44, wav.length-44);// 44:wavのヘッダサイズ
            audioTrack.play();
        }
    }

}