package com.example.helloaquestalk;

import android.media.AudioTrack;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import java.io.FileOutputStream;
import java.io.IOException;

import aquestalk.AquesTalk;	// AquesTalkクラス 別途libAquesTalk.soが必要

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        String koe = "ゆっくりしていってね？";
        int    speed = 90; // 発話速度　50-300　default:100
        String devKey = "xxxxxxx"; // 開発ライセンスキー
        String usrKey = "yyyyyyy"; // 使用ライセンスキー
        // 音声合成
        AquesTalk aquestalk = new AquesTalk();
        aquestalk.setDevKey(devKey);
        aquestalk.setUsrKey(usrKey);
        byte[] wav = aquestalk.syntheWav(koe, speed);
        if(wav.length==1){//生成エラー時には,長さ１で、先頭にエラーコードが返される
            Log.v("AQTKAPP", "AquesTalk Synthe ERROR:"+wav[0]);
        }
        else {
            PlayWav(wav);//音声データを再生出力
        }
        TextView textView = findViewById(R.id.text_view);
        textView.setText("音声記号列："+koe+" speed:"+speed);
    }
    private void PlayWav(byte[] wav) {
        // 一旦ファイルに出力してから、MediaPlayerで再生
        String tmpfilename = "tmp_hello.wav";
        String packagename = removeSuffix(this.getClass().getName());

        try {
            FileOutputStream fileOutputStream = openFileOutput(tmpfilename, MODE_PRIVATE );
            fileOutputStream.write(wav);
            fileOutputStream.close();
        } catch (IOException e) {
            Log.e("AQTKAPP", "ERR: FileOutputStream");
        }
        try {
            MediaPlayer mp = new MediaPlayer();
            // mp.reset();	// MediaPlayerインスタンスを複数回使うときは必要
            mp.setDataSource("/data/data/"+packagename+"/files/"+tmpfilename);
            mp.prepare();	//<<忘れると動かない　(-38,0)のようなエラーがでる
            mp.start();
        } catch (IOException e) {
        }
    }

    public static String removeSuffix(String fileName) {
        if (fileName == null)
            return null;
        int point = fileName.lastIndexOf(".");
        if (point != -1) {
            return fileName.substring(0, point);
        }
        return fileName;
    }

}