/*////////////////////////////////////////////////////////////////////

	規則音声合成エンジン AquesTalk10 Java

  音声記号列から音声波形データをメモリ上に生成する
  出力音声波形は、16KHz, 16bit,モノラル,WAVフォーマット。
                  *サンプリング周波数は、声種パラメータfscにより変化

	@author	N.Yamazaki (AQUEST)

	@date	2017/10/22	N.Yamazaki	Creation
////////////////////////////////////////////////////////////////////*/
package aquestalk;

public class AquesTalk {

    // プリセット声種
    public final class PRESET {
        public static final int F1 = 0;
        public static final int F2 = 1;
        public static final int F3 = 2;
        public static final int M1 = 3;
        public static final int M2 = 4;
        public static final int R1 = 5;
        public static final int R2 = 6;
    }
    // 基本素片
    public final class BAS {
        public static final int F1E = 0;
        public static final int F2E = 1;
        public static final int M1E = 2;
    }

    // 声質パラメータ
    public int bas;    // 基本素片 F1E/F2E/M1E (0/1/2)
    public int spd;    // 話速 	50-300 default:100
    public int vol;    // 音量 	0-300 default:100
    public int pit;    // 高さ 	20-200 default:基本素片に依存
    public int acc;    // アクセント 0-200 default:基本素片に依存
    public int lmd;    // 音程１ 	0-200 default:100
    public int fsc;    // 音程２(サンプリング周波数) 50-200 default:100

	// コンストラクタ
    public AquesTalk() {
        SetPreset(PRESET.F1); // デフォルトコンストラクタの声種はF1
    }

    public AquesTalk(int preset) {
        SetPreset(preset);
    }

    // 音声を合成
	// 	kanaText 音声記号列(UTF-8)
	//  return wavフォーマットのデータ エラーの場合はsize=1でエラーコードが入る
    public byte[] synthe(String kanaText) {
        return syntheWav(kanaText, bas, spd, vol, pit, acc, lmd, fsc);
    }

    // 声質パラメータを、指定のプリセット声種にセット
    public void SetPreset(int preset) {
        if (preset == PRESET.F2) {
            this.bas = BAS.F2E;
            this.spd = 100;
            this.vol = 100;
            this.pit = 77;
            this.acc = 150;
            this.lmd = 100;
            this.fsc = 100;
        } else if (preset == PRESET.F3) {
            this.bas = BAS.F1E;
            this.spd = 80;
            this.vol = 100;
            this.pit = 100;
            this.acc = 100;
            this.lmd = 61;
            this.fsc = 148;
        } else if (preset == PRESET.M1) {
            this.bas = BAS.M1E;
            this.spd = 100;
            this.vol = 100;
            this.pit = 30;
            this.acc = 100;
            this.lmd = 100;
            this.fsc = 100;
        } else if (preset == PRESET.M2) {
            this.bas = BAS.M1E;
            this.spd = 105;
            this.vol = 100;
            this.pit = 45;
            this.acc = 130;
            this.lmd = 120;
            this.fsc = 100;
        } else if (preset == PRESET.R1) {
            this.bas = BAS.M1E;
            this.spd = 100;
            this.vol = 100;
            this.pit = 30;
            this.acc = 20;
            this.lmd = 190;
            this.fsc = 100;
        } else if (preset == PRESET.R2) {
            this.bas = BAS.F2E;
            this.spd = 70;
            this.vol = 100;
            this.pit = 50;
            this.acc = 50;
            this.lmd = 50;
            this.fsc = 180;
        } else { // default F1
            this.bas = BAS.F1E;
            this.spd = 100;
            this.vol = 100;
            this.pit = 100;
            this.acc = 100;
            this.lmd = 100;
            this.fsc = 100;
        }
    }

	////////////////////////////////////////////
	// Java Native Interface functins
    static {
        System.loadLibrary("AquesTalk");
    }
	// 音声生成
    protected static synchronized native byte[] syntheWav(String kanaText, int bas, int spd, int vol, int pit, int acc, int lmd, int fsc);

    // 開発ライセンスキー設定
    public static native int setDevKey(String devkey);

    // 使用ライセンスキー設定
    public static native int setUsrKey(String usrkey);
}
//  ----------------------------------------------------------------------
// !  Copyright AQUEST Corp. 2006- .  All Rights Reserved.                !
// !  An unpublished and CONFIDENTIAL work.  Reproduction, adaptation, or !
// !  translation without prior written permission is prohibited except   !
// !  as allowed under the copyright laws.                                !
//  ----------------------------------------------------------------------
