package com.example.aqtkapp;

import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import aquestalk.AquesTalk;    // AquesTalkクラス 別途libAquesTalk.soが必要

public class MainActivity extends AppCompatActivity {
    AquesTalk aquestalk;
    AudioTrack audioTrack;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

//        int iret = AquesTalk.setDevKey("xxx-xxx-xxx"); // 開発ライセンスキーを指定
//        int iret2 = AquesTalk.setUsrKey("zzz-zzz-zzz"); // 使用ライセンスキーを指定
        aquestalk = new AquesTalk();
        Button playButton = findViewById(R.id.button_synthe);

        playButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {
                aquestalk.SetPreset(AquesTalk.PRESET.F1);
                aquestalk.spd = ((SeekBar) findViewById(R.id.spd)).getProgress() + 50;
                aquestalk.pit = ((SeekBar) findViewById(R.id.pit)).getProgress() + 20;
                aquestalk.lmd = ((SeekBar) findViewById(R.id.lmd)).getProgress();
                EditText textKoe = findViewById(R.id.text_koe);
                String koe = textKoe.getText().toString();
                onPlayBtn(koe);
            }
        });
    }

    @Override
    public void onDestroy() {
        if (audioTrack != null) audioTrack.release();
        super.onDestroy();
    }

    private void onPlayBtn(String koe) {
        // 音声合成
        byte[] wav = aquestalk.synthe(koe);
        if (wav.length == 1) {//生成エラー時には,長さ１で、先頭にエラーコードが返される
            Log.v("AQTKAPP", "AquesTalk Synthe ERROR:" + wav[0]);
            Toast.makeText(this, "音声記号列が正しい？：" + wav[0], Toast.LENGTH_LONG).show();
        } else {    // 音声出力
            if (audioTrack != null) {// インスタンスがあれば停止/解放
                audioTrack.stop();
                audioTrack.release();
            }
            audioTrack = new AudioTrack(
                    AudioManager.STREAM_MUSIC,
                    (wav[25] << 8) + wav[24], // WAVヘッダからサンプリング周波数[Hz]を取得
                    AudioFormat.CHANNEL_OUT_MONO,
                    AudioFormat.ENCODING_PCM_16BIT,
                    wav.length - 44,
                    AudioTrack.MODE_STATIC);
            audioTrack.write(wav, 44, wav.length - 44);// 44:wavのヘッダサイズ
            audioTrack.play();
        }
    }

}