package com.example.aqtk2app;

import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import java.io.IOException;
import java.io.InputStream;

import aquestalk2.AquesTalk2;	// AquesTalk2クラス 別途libAquesTalk2.soが必要

public class MainActivity extends AppCompatActivity {
    AquesTalk2 aquestalk2;
    AudioTrack audioTrack;
    private static final int FS = 8000;	//[Hz]

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);

        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        aquestalk2 = new AquesTalk2();
        Button playButton = findViewById(R.id.button_synthe);

        playButton.setOnClickListener(new View.OnClickListener(){
            public void onClick(View view){
                EditText textKoe = findViewById(R.id.text_koe);
                EditText textSpeed = findViewById(R.id.text_speed);
                Spinner objPhont = findViewById(R.id.text_phont);
                String koe = textKoe.getText().toString();
                int speed = Integer.parseInt(textSpeed.getText().toString());
                String phont = (String)objPhont.getSelectedItem();
                onPlayBtn(koe,speed,phont);
            }
        });

    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if(audioTrack!=null) audioTrack.release();
    }

    private void onPlayBtn(String koe, int speed, String phont) {
        byte[] phontDat = LoadPhont(phont);
        // 音声合成
        byte[] wav = aquestalk2.syntheWav(koe, speed, phontDat);
        if(wav.length==1){//生成エラー時には,長さ１で、先頭にエラーコードが返される
            Log.v("AQTK2APP", "AquesTalk2 Synthe ERROR:" + wav[0]);
            Toast.makeText(this, "音声記号列が正しい？："+wav[0], Toast.LENGTH_LONG).show();
        }
        else { // 音声出力
            playWav(wav, wav.length);
        }
    }
    private void playWav(byte[] wav, int len) {
        if(audioTrack!=null) {// 発声中なら停止/解放
            audioTrack.stop();
            audioTrack.release();
        }
        audioTrack = new AudioTrack(
                AudioManager.STREAM_MUSIC,
                FS,
                AudioFormat.CHANNEL_OUT_MONO,
                AudioFormat.ENCODING_PCM_16BIT,
                len-44,
                AudioTrack.MODE_STATIC);
        audioTrack.write(wav, 44, len-44);// 44:wavのヘッダサイズ
        audioTrack.play();
    }

    // 指定のPhont名に等しいPhontデータをリソースからLoad
    private byte[] LoadPhont(String phont) {
        try {
            String packageName = getResources().getResourcePackageName(R.raw.aq_robo);
            String typeName = getResources().getResourceTypeName(R.raw.aq_robo);
            int resID = getResources().getIdentifier(phont,typeName, packageName);
            if(resID==0) return null;
            InputStream in = getResources().openRawResource(resID);
            int size = in.available();	// リソースのデータサイズ
            byte[] phontDat = new byte[size];
            in.read(phontDat);
            return phontDat;
        }catch (IOException e) {
            return null;
        }
    }

}