package com.example.helloaquestalk2;

import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import java.io.IOException;
import java.io.InputStream;

import aquestalk2.AquesTalk2;	// AquesTalk2クラス 別途libAquesTalk2.soが必要

public class MainActivity extends AppCompatActivity {
    AudioTrack audioTrack;
    private static final int FS = 8000;	//[Hz]

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        String koe = "ゆっくりしていってね？";
        int    speed = 90; // 発話速度　50-300　default:100
        int	   phontResID = R.raw.aq_robo;	// 声種

   		// リソースからPhontデータを読み込み (デフォルトのPhontを使用するときは不要）
    	InputStream in = getResources().openRawResource(phontResID);
        int size = 0;	// リソースのデータサイズ
        try {
            size = in.available();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] phontDat = new byte[size];
        try {
            in.read(phontDat);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        // 音声合成
    	AquesTalk2 aquestalk2 = new AquesTalk2();
    	byte[] wav = aquestalk2.syntheWav(koe, speed, phontDat);
//    	byte[] wav = aquestalk2.syntheWav(koe, speed, null);  //< デフォルトのPhontを使用する場合
//      byte[] wav = AquesTalk2.synthe(koe, speed, phontDat); //< 静的メソッドもOK

        if(wav.length==1){//生成エラー時には,長さ１で、先頭にエラーコードが返される
            Log.v("AQTKAPP", "AquesTalk2 Synthe ERROR:"+wav[0]);
        }
        else {
            //音声データを再生出力
            if(audioTrack!=null) {// インスタンスがあれば停止/解放
                audioTrack.stop();
                audioTrack.release();
            }
            audioTrack = new AudioTrack(
                    AudioManager.STREAM_MUSIC,
                    FS,
                    AudioFormat.CHANNEL_OUT_MONO,
                    AudioFormat.ENCODING_PCM_16BIT,
                    wav.length-44,
                    AudioTrack.MODE_STATIC);
            audioTrack.write(wav, 44, wav.length-44);// 44:wavのヘッダサイズ
            audioTrack.play();
        }
        TextView textView = findViewById(R.id.text_view);
//        textView.setText("音声記号列："+koe+" speed:"+speed);
     	textView.setText("音声記号列："+koe
     			+" speed:"+speed
     			+" phont:"+getResources().getResourceEntryName(phontResID));

    }
    @Override
    public void onDestroy() {
        if(audioTrack!=null) audioTrack.release();
        super.onDestroy();
    }
}
